/*
 * draw Sierpinski curves
 * a+ds=pgms pg 136
 */

#include <stdio.h>

#define MAXITR	6
#define MAXCLRS	8
#define SIZE 1024

struct{ char	r;
	char	g;
	char	b;
	char	off;
	} clrtbl[MAXCLRS];

struct{	char	r;
	char	g;
	char	b;
	} savtbl[MAXCLRS];

	char*	clr="\0\1\2\3\4\5\6\7";
	long	numvecs;
	int	i,h,x,y,x0,y0;

main(){
	i=0;
	h = SIZE/4;
	x0 = 2*h;
	y0 = 3*h;
	printf("\033G18888");
	putchar('e');
	putw(200,stdout);
	setclr(8,0,0,0);
	putw((0x800|'['),stdout);
	printf("~");
	setclr(1,150,130,0);
	setclr(2,0,150,0);
	setclr(3,0,200,200);
	setclr(4,200,200,0);
	setclr(5,0,0,250);
	setclr(6,200,0,180);
	do{
	 off(i-2);
	 i=i+1;
	 putw((clr[i]<<8)|'C',stdout);
	 x0 = x0-h;
	 h = h/2;
	 y0 = y0+h;
	 x= x0;
	 y = y0;
	 move(x,y);
	 a(i); x=x+h; y=y-h; plot();
	 b(i); x=x-h; y=y-h; plot();
	 c(i); x=x-h; y=y+h; plot();
	 d(i); x=x+h; y=y+h; plot();
	}
	 while(i<MAXITR);

	while(1){
	on(2);
	mod(2);
	on(3);
	mod(3);
	on(4);
	mod(4);
	on(5);
	mod(5);
	on(6);
	mod(6);
	off(6);
	mod(3);
	off(2);
	mod(4);
	mod(5);
	on(2);
	off(4);
	on(6);
	mod(6);
	mod(4);
	mod(3);
	on(4);
	mod(2);
	}

	fprintf(stderr,"total vectors = %ld\n",numvecs);
}

on(clr){
	if(clrtbl[clr].off > 0){ /* can't turn on if it ain't been off... */
	 setclr(clr,savtbl[clr].r,savtbl[clr].g,savtbl[clr].b);
	 clrtbl[clr].off = 0;
	}
}

off(clr){
	if(clr>0){
	/* save the current colors */
	 savtbl[clr].r = clrtbl[clr].r;
	 savtbl[clr].g = clrtbl[clr].g;
	 savtbl[clr].b = clrtbl[clr].b;
	/* clear active entry */
	 setclr(clr,0,0,0);
	/* mark color as off */
	 clrtbl[clr].off++;
	}
}

mod(clr){
	int orgr,orgg,orgb;
	int newr,newg,newb;
	if(clrtbl[clr].off == 0){
	 newr = orgr = clrtbl[clr].r;
	 newg = orgg = clrtbl[clr].g;
	 newb = orgb = clrtbl[clr].b;
/*
 * raise the clr till one of 'em hits 250, then go the other way to 0
 */

	 while( (newr<250) && (newg<250) && (newb<250) ){
	  if(newr) newr+=5;
	  if(newg) newg+=5;
	  if(newb) newb+=5;
 	  setclr(clr,newr,newg,newb);
	 }
	 while( (newr<250) && (newg<250) && (newb<250) ){
	  if(newr) newr-=5;
	  if(newg) newg-=5;
	  if(newb) newb-=5;
	  setclr(clr,newr,newg,newb);
	 }
	 setclr(clr,orgr,orgg,orgb);
	}
}	

a(i){
	if(i>0){
	 a(i-1); x=x+h; y=y-h; plot();
	 b(i-1); x=x+2*h; plot();
	 d(i-1); x=x+h; y=y+h; plot();
	 a(i-1);
	}
}

b(i){
	if(i>0){
	 b(i-1); x=x-h; y=y-h; plot();
	 c(i-1); y=y-2*h; plot();
	 a(i-1); x=x+h; y=y-h; plot();
	 b(i-1);
	}
}

c(i){
	if(i>0){
	 c(i-1); x=x-h; y=y+h; plot();
	 d(i-1); x=x-2*h; plot();
	 b(i-1); x=x-h; y=y-h; plot();
	 c(i-1);
	}
}

d(i){
	if(i>0){
	 d(i-1); x=x+h; y=y+h; plot();
	 a(i-1); y=y+2*h; plot();
	 c(i-1); x=x-h; y=y+h; plot();
	 d(i-1);
	}
}

move(){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'Q';
	lxy = ((y&0xff)<<8)|(x&0xff);
	putw(hxy,stdout);
	putw(lxy,stdout);
}

plot(){
	register unsigned hxy,lxy;
	hxy  = (x&0xf00)<<4;
	hxy |= (y&0xf00);
	hxy |= 'A';
	lxy = ((y&0xff)<<8)|(x&0xff);
	putw(hxy,stdout);
	putw(lxy,stdout);
	numvecs++;
}

setclr(clr,r,g,b){

	clrtbl[clr].r = r;
	clrtbl[clr].g = g;
	clrtbl[clr].b = b;

	putc('K',stdout);
	putc(clr,stdout);
	putc(1,stdout);
	putc(r,stdout);
	putc(g,stdout);
	putc(b,stdout);
}
